/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.tag;

import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber
public class ModDimensionTags {
    public static final TagKey<DimensionType> SOUL_LAMP_VALID = ModDimensionTags.createTag("soulspring_lamp_valid");
    public static final TagKey<DimensionType> HAS_CEILING = ModDimensionTags.createForgeTag("has_ceiling");
    public static final TagKey<DimensionType> HAS_SKY = ModDimensionTags.createForgeTag("has_sky");
    public static final TagKey<DimensionType> NATURAL = ModDimensionTags.createForgeTag("natural");
    public static final TagKey<DimensionType> UNNATURAL = ModDimensionTags.createForgeTag("unnatural");
    public static final TagKey<DimensionType> ULTRAWARM = ModDimensionTags.createForgeTag("ultrawarm");
    public static final TagKey<DimensionType> BED_WORKS = ModDimensionTags.createForgeTag("bed_works");
    public static final TagKey<DimensionType> RESPAWN_ANCHOR_WORKS = ModDimensionTags.createForgeTag("respawn_anchor_works");
    public static final TagKey<DimensionType> PIGLIN_SAFE = ModDimensionTags.createForgeTag("piglin_safe");
    public static final TagKey<DimensionType> HAS_SKYLIGHT = ModDimensionTags.createForgeTag("has_skylight");
    public static final TagKey<DimensionType> HAS_RAIDS = ModDimensionTags.createForgeTag("has_raids");
    public static final TagKey<DimensionType> OVERWORLD_LIKE = ModDimensionTags.createForgeTag("overworld_like");
    private static final Field CONTENTS = ObfuscationReflectionHelper.findField(HolderSet.Named.class, (String)"f_205830_");

    private static TagKey<DimensionType> createTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122818_, (ResourceLocation)new ResourceLocation("cold_sweat", name));
    }

    private static TagKey<DimensionType> createForgeTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122818_, (ResourceLocation)new ResourceLocation("forge", name));
    }

    public static void initDynamicTags(RegistryAccess registryAccess) {
        ModDimensionTags.fillTag(HAS_CEILING, DimensionType::f_63856_, registryAccess);
        ModDimensionTags.fillTag(HAS_SKY, dimensionType -> !dimensionType.f_63856_(), registryAccess);
        ModDimensionTags.fillTag(NATURAL, DimensionType::f_63858_, registryAccess);
        ModDimensionTags.fillTag(UNNATURAL, dimensionType -> !dimensionType.f_63858_(), registryAccess);
        ModDimensionTags.fillTag(ULTRAWARM, DimensionType::f_63857_, registryAccess);
        ModDimensionTags.fillTag(BED_WORKS, DimensionType::f_63862_, registryAccess);
        ModDimensionTags.fillTag(RESPAWN_ANCHOR_WORKS, DimensionType::f_63863_, registryAccess);
        ModDimensionTags.fillTag(PIGLIN_SAFE, DimensionType::m_63960_, registryAccess);
        ModDimensionTags.fillTag(HAS_SKYLIGHT, DimensionType::f_223549_, registryAccess);
        ModDimensionTags.fillTag(HAS_RAIDS, DimensionType::m_63963_, registryAccess);
        ModDimensionTags.fillTag(OVERWORLD_LIKE, dimensionType -> !dimensionType.f_63856_() && dimensionType.f_63858_() && dimensionType.f_223549_() && !dimensionType.f_63857_(), registryAccess);
    }

    private static void fillTag(TagKey<DimensionType> tag, Predicate<DimensionType> predicate, RegistryAccess registryAccess) {
        HashSet entries;
        Registry dimensionRegistry = registryAccess.m_175515_(Registry.f_122818_);
        HolderSet.Named holderSet = (HolderSet.Named)dimensionRegistry.m_203431_(tag).get();
        try {
            entries = new HashSet((List)CONTENTS.get(holderSet));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        dimensionRegistry.m_203611_().forEach(dimensionType -> {
            if (predicate.test((DimensionType)dimensionType.m_203334_())) {
                entries.add(dimensionType);
                dimensionType.m_205769_(ListBuilder.begin(dimensionType.m_203616_().toList()).add((List<TagKey>)tag).build());
            }
        });
        holderSet.m_205835_(new ArrayList(entries));
    }

    @SubscribeEvent
    public static void onServerStart(ServerConfigsLoadedEvent event) {
        ModDimensionTags.initDynamicTags((RegistryAccess)event.getServer().m_206579_());
    }

    static {
        CONTENTS.setAccessible(true);
    }
}

